/*
 * read a line into words
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

int any(caddr_t, int);

char **line2words(
	char *buf,
	char *seps,
	int  wmax,
	int *wcnt)
{
	char        *wp;
	int          wc;
	char       **words;

	if (wmax < 1 || wmax > BUFSIZ) wmax = BUFSIZ;

	words = (char **) malloc(sizeof(char *) * BUFSIZ);
	if (words == NULL) {
		perror("malloc");
		exit(1);
	}

	wc = 0;
	wp = buf;
	while (wc < wmax) {
		while (any(seps, *wp)) ++wp;
		if (*wp == '\0') break;

		words[wc++] = wp;
		while (!any(seps, *wp) && *wp != '\0') ++wp;
		if (wc < wmax && *wp != '\0') *wp++ = '\0';
	}

	if (wcnt) *wcnt = wc;
	return words;
}

int any(
	caddr_t s,
	int c)
{
	while (*s) if (*s++ == c) return 1;
	return 0;
}

